/*
 * Decompiled with CFR 0.152.
 */
package razeni;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import razeni.Sipka;

public class Platno
extends JPanel {
    private int[] vykreslovanePole = null;
    private Sipka[] sipky = null;
    private int minX;
    private int minY;
    private int maxX;
    private int maxY;

    Platno() {
        this.setOpaque(true);
    }

    @Override
    public Insets getInsets() {
        return new Insets(10, 10, 10, 10);
    }

    public void nakresli(int[] nArray) {
        this.vykreslovanePole = nArray;
        this.repaint();
    }

    public void nakresli(int[] nArray, Sipka[] sipkaArray) {
        this.vykreslovanePole = nArray;
        this.sipky = sipkaArray;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Insets insets = this.getInsets();
        this.minX = (int)((double)insets.left * 1.5);
        this.minY = insets.top;
        this.maxX = (int)((double)this.getWidth() - (double)insets.right * 1.5 - 1.0);
        this.maxY = (int)((double)this.getHeight() - (double)insets.bottom * 1.5 - 1.0);
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.vykresliPole(graphics2D);
    }

    private void vykresliPole(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Font font = new Font("Arial", 1, (int)(0.05 * Math.log(this.maxY / 10 + 1) * 80.0));
        graphics2D.setFont(font);
        if (this.vykreslovanePole != null) {
            int n;
            for (n = 0; n < this.vykreslovanePole.length; ++n) {
                this.vykresliSloupecPole(graphics2D, this.vykreslovanePole[n], n);
            }
            for (n = 0; n < this.sipky.length; ++n) {
                this.vykresliSipku(graphics2D, this.sipky[n], n);
            }
        }
    }

    private void vykresliSloupecPole(Graphics2D graphics2D, int n, int n2) {
        Color color;
        int n3;
        int n4 = this.vykreslovanePole.length;
        if (this.vykreslovanePole[this.vykreslovanePole.length - 2] == 0) {
            n4 -= 2;
        }
        if (n == 0) {
            return;
        }
        if ((double)n4 / 4.0 >= (double)(n = n4 - n)) {
            n3 = 255 * n * 4 / n4;
            if (n3 > 255) {
                n3 = 255;
            }
            color = new Color(255, n3, 0);
        } else if ((double)n4 / 2.0 >= (double)n) {
            int n5;
            n3 = n - n4 / 4;
            if (n3 == 0) {
                n3 = 1;
            }
            if ((n5 = 255 * n3 * 4 / n4) > 255) {
                n5 = 255;
            }
            if ((n5 = 255 - (int)(Math.log((double)(255 - n5) / 10.0 + 1.0) * 77.7)) < 0) {
                n5 = 0;
            }
            color = new Color(255 - n5, 255, 0);
        } else if ((double)n4 / 4.0 * 3.0 >= (double)n) {
            int n6;
            n3 = n - n4 / 2;
            if (n3 == 0) {
                n3 = 1;
            }
            if ((n6 = 255 * n3 * 4 / n4) > 255) {
                n6 = 255;
            }
            color = new Color(0, 255, n6);
        } else {
            int n7;
            n3 = n - n4 * 3 / 4;
            if (n3 == 0) {
                n3 = 1;
            }
            if ((n7 = 255 * n3 * 4 / n4) > 255) {
                n7 = 255;
            }
            color = new Color(n7, 255 - n7, 255);
        }
        n = n4 - n;
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
        double d = (double)(this.maxY - this.minY) * 0.8 / (double)n4 * (double)n;
        graphics2D.setPaint(new GradientPaint(0.0f, (float)((double)(this.maxY - this.minY) * 0.8 + (double)this.minY - d), color.brighter(), 0.0f, (float)((double)(this.maxY - this.minY) * 0.8 + (double)this.minY), color));
        Rectangle2D.Double double_ = new Rectangle2D.Double((double)(this.maxX - this.minX) / (double)this.vykreslovanePole.length * ((double)n2 + 0.25) + (double)this.minX, (double)(this.maxY - this.minY) * 0.8 + (double)this.minY - d, (double)(this.maxX - this.minX) / (double)this.vykreslovanePole.length / 2.0, d);
        graphics2D.fill(double_);
        graphics2D.setPaint(new Color(0, 0, 0));
        graphics2D.draw(double_);
    }

    private void vykresliSipku(Graphics2D graphics2D, Sipka sipka, int n) {
        graphics2D.setPaint(sipka.getBarva());
        double d = (double)(this.maxX - this.minX) / (double)this.vykreslovanePole.length / 2.0 / 4.0;
        d = -d + (double)n * d;
        double d2 = (double)(this.maxX - this.minX) / (double)this.vykreslovanePole.length * ((double)sipka.i + 0.5) + (double)this.minX + d;
        this.vykresliUkazatel(graphics2D, d2, (double)(this.maxY - this.minY) * 0.83 + (double)this.minY, (double)(this.maxY - this.minY) * 0.01, sipka.getRadek());
        FontMetrics fontMetrics = this.getFontMetrics(graphics2D.getFont());
        int n2 = fontMetrics.stringWidth(sipka.getPopisek());
        int n3 = graphics2D.getFont().getSize();
        graphics2D.setPaint(sipka.getBarva().darker());
        graphics2D.drawString(sipka.getPopisek(), (int)(d2 - (double)(n2 / 2)), (int)((double)(this.maxY - this.minY) * 0.99 + (double)this.minY + (double)n3 * 1.08 * (double)sipka.getRadek()));
    }

    private void vykresliUkazatel(Graphics2D graphics2D, double d, double d2, double d3, int n) {
        d = Math.round(d);
        d2 = Math.floor(d2);
        if ((d3 = (double)Math.round(d3)) < 1.0) {
            d3 = 1.0;
        }
        double[] dArray = new double[]{d, d + 4.0 * d3, d + 2.0 * d3, d + 2.0 * d3, d - 2.0 * d3, d - 2.0 * d3, d - 4.0 * d3, d};
        double[] dArray2 = new double[]{d2, d2 + 5.0 * d3, d2 + 5.0 * d3, d2 + 7.0 * d3 + (double)(4 * n) * d3, d2 + 7.0 * d3 + (double)(4 * n) * d3, d2 + 5.0 * d3, d2 + 5.0 * d3, d2};
        GeneralPath generalPath = new GeneralPath(0, dArray.length);
        generalPath.moveTo(dArray[0], dArray2[0]);
        for (int i = 1; i < dArray.length; ++i) {
            generalPath.lineTo(dArray[i], dArray2[i]);
        }
        generalPath.closePath();
        graphics2D.fill(generalPath);
        graphics2D.setPaint(Color.BLACK);
        graphics2D.draw(generalPath);
    }
}

