/*
 * Decompiled with CFR 0.152.
 */
package razeni;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JFrame;
import javax.swing.JPanel;
import razeni.Platno;
import razeni.Rizeni;

public abstract class AlgoritmusOkenko
extends JFrame
implements Runnable {
    public static final int DOSTATECNE_DLOUHY_CAS = 1000000;
    private Thread vlakno = null;
    protected String jmenoRazeni;
    private int pocetPorovnani;
    private int pocetPresunu;
    private boolean jeZobrazeno = false;
    private boolean razeniZacalo = false;
    private boolean razeniSkoncilo = false;
    protected Platno platno;
    protected int[] pole;

    public AlgoritmusOkenko(int n, int n2) {
        this.add(this.vytvorVnitrek());
        this.setLocation(n, n2);
        this.pack();
        this.setVisible(this.jeZobrazeno);
    }

    private Container vytvorVnitrek() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.platno = new Platno();
        this.platno.setBackground(Color.WHITE);
        this.platno.setPreferredSize(new Dimension(this.sirkaMonitoru() / 2 - 8, (this.vyskaMonitoru() - 30) / 3 - 34));
        jPanel.add((Component)this.platno, "Center");
        return jPanel;
    }

    private void zmenTitulek() {
        String string = this.jmenoRazeni + " (porovn\u00e1n\u00ed: " + this.pocetPorovnani + ", p\u0159esun\u016f: " + this.pocetPresunu + ")";
        this.setTitle(string);
    }

    public int sirkaMonitoru() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        return dimension.width;
    }

    public int vyskaMonitoru() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        return dimension.height;
    }

    public void nastavPocetPresunu(int n) {
        this.pocetPresunu = n;
        this.zmenTitulek();
    }

    public void nastavPocetPorovnani(int n) {
        this.pocetPorovnani = n;
        this.zmenTitulek();
    }

    public void zvysPocetPresunu(int n) {
        this.pocetPresunu += n;
        this.zmenTitulek();
    }

    public void zvysPocetPresunu() {
        ++this.pocetPresunu;
        this.zmenTitulek();
    }

    public void zvysPocetPorovnani(int n) {
        this.pocetPorovnani += n;
        this.zmenTitulek();
    }

    public void zvysPocetPorovnani() {
        ++this.pocetPorovnani;
        this.zmenTitulek();
    }

    public void setTitulek(String string) {
        this.setTitle(string);
    }

    public void zobrazit() {
        this.jeZobrazeno = true;
        this.setVisible(this.jeZobrazeno);
    }

    public void skryt() {
        this.jeZobrazeno = false;
        this.setVisible(this.jeZobrazeno);
    }

    public boolean jeZobrazeno() {
        return this.jeZobrazeno;
    }

    public boolean zacaloUzRazeni() {
        return this.razeniZacalo;
    }

    public boolean skonciloUzRazeni() {
        return this.razeniSkoncilo;
    }

    public void nastavStavRazeni() {
        this.razeniZacalo = false;
        this.razeniSkoncilo = false;
    }

    protected void nastavPole(int[] nArray) {
        this.pole = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.pole[i] = nArray[i];
        }
    }

    public void start() {
        this.vlakno = new Thread(this);
        this.razeniZacalo = false;
        this.razeniSkoncilo = false;
        this.vlakno.start();
    }

    @Override
    public void run() {
        this.razeniZacalo = true;
        this.razeni();
        this.razeniSkoncilo = true;
    }

    public void interrupt() {
        this.vlakno.interrupt();
    }

    public void stop() {
        this.vlakno.stop();
        this.razeniSkoncilo = true;
    }

    protected abstract void razeni();

    protected void cekani() {
        try {
            if (Rizeni.krokovani) {
                Thread.sleep(1000000L);
            } else {
                Thread.sleep(Rizeni.getProdlevaMs());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void cekani(double d) {
        try {
            if (Rizeni.krokovani) {
                Thread.sleep(1000000L);
            } else {
                Thread.sleep((int)((double)Rizeni.getProdlevaMs() * d));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

