/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class Oslava
extends JApplet
implements Observer {
    private static final DecimalFormat df = new DecimalFormat("#,###.##");
    private DatumACas narozeni;
    private DatumACas oslava;
    private JTextField pocetTF;
    private ButtonGroup casovaJednotkaBG;
    private JRadioButton vterinyRB;
    private JRadioButton minutyRB;
    private JRadioButton hodinyRB;
    private JRadioButton dnyRB;
    private JRadioButton tydnyRB;
    private JRadioButton mesiceRB;
    private JRadioButton rokyRB;
    private int[] naJednotky = new int[]{13, 12, 11, 5, 3, 2, 1};
    private int[] naPocet = new int[]{1, 60, 3600, 86400, 604800, 2628000, 31536000};

    public void init() {
        this.narozeni = new DatumACas("Datum narozen\u00ed");
        this.oslava = new DatumACas("Datum oslavy");
        this.narozeni.addObserver(this);
        this.oslava.addObserver(this);
        this.pocetTF = new JTextField(10);
        this.pocetTF.setHorizontalAlignment(0);
        this.casovaJednotkaBG = new ButtonGroup();
        this.vterinyRB = new JRadioButton("vte\u0159iny");
        this.minutyRB = new JRadioButton("minuty");
        this.hodinyRB = new JRadioButton("hodiny");
        this.dnyRB = new JRadioButton("dny");
        this.tydnyRB = new JRadioButton("t\u00fddny");
        this.mesiceRB = new JRadioButton("m\u011bs\u00edce");
        this.rokyRB = new JRadioButton("roky", true);
        this.vterinyRB.setMnemonic(0);
        this.minutyRB.setMnemonic(1);
        this.hodinyRB.setMnemonic(2);
        this.dnyRB.setMnemonic(3);
        this.tydnyRB.setMnemonic(4);
        this.mesiceRB.setMnemonic(5);
        this.rokyRB.setMnemonic(6);
        this.casovaJednotkaBG.add(this.vterinyRB);
        this.casovaJednotkaBG.add(this.minutyRB);
        this.casovaJednotkaBG.add(this.hodinyRB);
        this.casovaJednotkaBG.add(this.dnyRB);
        this.casovaJednotkaBG.add(this.tydnyRB);
        this.casovaJednotkaBG.add(this.mesiceRB);
        this.casovaJednotkaBG.add(this.rokyRB);
        this.getContentPane().add(this.vytvorVnitrek());
        this.obsluhyUdalosti();
        GregorianCalendar gregorianCalendar = new GregorianCalendar(1970, 11, 31, 12, 0);
        this.narozeni.nastavDatum(gregorianCalendar);
        this.narozeni.vypisCas();
        this.oslava.nastavDatum(Calendar.getInstance());
        this.oslava.vypisCas();
        this.oslava.nactiCas();
    }

    private Container vytvorVnitrek() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        JPanel jPanel2 = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(" \u010casov\u00e9 jednotky ");
        jPanel2.setBorder(titledBorder);
        jPanel2.setLayout(new GridLayout(3, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.add(new JLabel("po\u010det"));
        jPanel3.add(this.pocetTF);
        jPanel2.add(jPanel3);
        jPanel3 = new JPanel();
        jPanel3.add(this.vterinyRB);
        jPanel3.add(this.minutyRB);
        jPanel3.add(this.hodinyRB);
        jPanel2.add(jPanel3);
        jPanel3 = new JPanel();
        jPanel3.add(this.dnyRB);
        jPanel3.add(this.tydnyRB);
        jPanel3.add(this.mesiceRB);
        jPanel3.add(this.rokyRB);
        jPanel2.add(jPanel3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.narozeni.getPanel(), gridBagConstraints);
        jPanel.add(this.narozeni.getPanel());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.oslava.getPanel(), gridBagConstraints);
        jPanel.add(this.oslava.getPanel());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private void obsluhyUdalosti() {
        this.vterinyRB.addActionListener(new ALRB());
        this.minutyRB.addActionListener(new ALRB());
        this.hodinyRB.addActionListener(new ALRB());
        this.dnyRB.addActionListener(new ALRB());
        this.tydnyRB.addActionListener(new ALRB());
        this.mesiceRB.addActionListener(new ALRB());
        this.rokyRB.addActionListener(new ALRB());
        this.pocetTF.addActionListener(new ALpocetTF());
        this.pocetTF.addFocusListener(new FApocetTF());
    }

    private String zaokrouhli() {
        return this.zaokrouhli(this.pocetTF.getText());
    }

    private String zaokrouhli(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (stringBuffer.indexOf(",") >= 0) {
            stringBuffer.setCharAt(stringBuffer.indexOf(","), '.');
        }
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (Character.isDigit(stringBuffer.charAt(i)) || stringBuffer.charAt(i) == '.') continue;
            stringBuffer.deleteCharAt(i);
        }
        String string2 = stringBuffer.toString();
        if (string2.indexOf(".") >= 0) {
            BigDecimal bigDecimal = new BigDecimal(string2);
            bigDecimal = bigDecimal.setScale(0, 4);
            string2 = bigDecimal.toString();
        }
        this.pocetTF.setText(df.format(Double.parseDouble(string2)));
        return string2;
    }

    private void presnyPocet(int n) {
        Calendar calendar = this.narozeni.getCalendar();
        Calendar calendar2 = this.oslava.getCalendar();
        boolean bl = true;
        for (int i = 1; i < n; ++i) {
            if (i == 4 || calendar.get(this.naJednotky[i]) == calendar2.get(this.naJednotky[i])) continue;
            bl = false;
        }
        double d = (double)this.getPocetVterin() / (double)this.naPocet[n];
        String string = df.format(d);
        if (bl) {
            this.zaokrouhli(string);
        } else {
            if (string.indexOf(44) < 0 && string.indexOf(46) < 0) {
                DecimalFormat decimalFormat = new DecimalFormat("#,###.######");
                string = decimalFormat.format(d);
            }
            this.pocetTF.setText(string);
        }
    }

    private void aktualizujPocet() {
        int n = this.coJeNastaveno();
        if (n == 0 || n == 4) {
            double d = (double)this.getPocetVterin() / (double)this.naPocet[n];
            String string = df.format(d);
            this.pocetTF.setText(string);
        } else {
            this.presnyPocet(n);
        }
    }

    private int getPocet() {
        return Integer.parseInt(this.zaokrouhli());
    }

    private void aktualizujDatum() {
        int n = this.coJeNastaveno();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.narozeni.getCalendar().getTime());
        int n2 = this.getPocet();
        calendar.add(this.naJednotky[n], n2);
        this.oslava.nastavDatum(calendar);
        this.oslava.vypisCas();
    }

    private long getPocetVterin() {
        long l = this.narozeni.getVteriny();
        return this.oslava.getVteriny() - l;
    }

    public void update(Observable observable, Object object) {
        this.aktualizujPocet();
    }

    private int coJeNastaveno() {
        return this.casovaJednotkaBG.getSelection().getMnemonic();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("V\u00edte, kdy slavit?");
        Oslava oslava = new Oslava();
        jFrame.getContentPane().add(oslava);
        ((Applet)oslava).init();
        jFrame.setLocation(100, 10);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private class FApocetTF
    extends FocusAdapter {
        private FApocetTF() {
        }

        public void focusLost(FocusEvent focusEvent) {
            Oslava.this.aktualizujDatum();
        }

        public void focusGained(FocusEvent focusEvent) {
            Oslava.this.zaokrouhli();
            Oslava.this.pocetTF.selectAll();
        }
    }

    private class ALpocetTF
    implements ActionListener {
        private ALpocetTF() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Oslava.this.aktualizujDatum();
        }
    }

    private class ALRB
    implements ActionListener {
        private ALRB() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Oslava.this.aktualizujPocet();
        }
    }
}

