package demo2;

import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.util.*;
import javax.swing.*;


public class PictureLabel extends JLabel {
	
	private Image background;
				
	private ArrayList mPictures = new ArrayList();	// MoveablePicture List
	private Iterator it;

	public PictureLabel(Image background) {
		this.background = background;
		setOpaque(true);			 // DULEZITE !
		addMouseListener(new ClickListener());	 // Zaregisrujeme si vlastniho posluchace
	}

	public void addMoveablePicture(MoveablePicture mp){
		mPictures.add(mp);
	}
	
	public void paintComponent(Graphics g) {
		g.drawImage(background,0,0,null);
		
		it = mPictures.iterator();
		while(it.hasNext()) {
			MoveablePicture mp = (MoveablePicture) it.next();
			mp.paint(g);
		}
	}
	
	/**
	 * Posluchac vlastnch kliknut - disribuuje je dl na objetky typu MoveablePicture
	 */
	class ClickListener extends MouseAdapter {
		public void mouseClicked(MouseEvent e) {
			MoveablePicture mp;
			boolean oneHasBeenClicked = false;
			
			Point click = e.getPoint();
			ListIterator lit = mPictures.listIterator(mPictures.size());
			while(lit.hasPrevious()) {
				mp = (MoveablePicture) lit.previous();
				if (mp.contains(click)) {
					mp.processEvent(e);
					oneHasBeenClicked = true;
					break;
				}
			}
			
			/// jeslize se nekliklo na MoveablePicture, tak s kliknutim nalozte
			/// jak chcete
			if (!oneHasBeenClicked) {
				//
				// Tady muze byt obsluha, kterou chceme 
				// provest primo nad PictureLabelem
				//
			}
		}
	}
}


