
package demo2;

import java.applet.*;
import java.awt.event.*;
import java.awt.*;
import java.awt.image.*;
import java.io.*;
import javax.imageio.*;
import javax.swing.*;


public class DemoApplet extends JApplet implements Runnable {
	private PictureLabel pLabel;
	private MoveablePicture mPicture;
	private boolean goes = true;
	
	/**
	 * Inicializuje applet a sput animaci.
	 */
	public void init() {
		pLabel = new PictureLabel(loadBackground());
		mPicture = new MoveablePicture(pLabel,loadLogo());
		
		// ZDE REGISTRUJEME POSLUCHACE PRO MoveablePicture
		mPicture.addActionListener(new MyActionListner());
		pLabel.addMoveablePicture(mPicture);
		
		this.getContentPane().setLayout(new BorderLayout());
		this.getContentPane().add(pLabel, BorderLayout.CENTER);
		this.start();
	}
	
	public void start(){
		(new Thread(this)).start();
	}
	public void run() {
		// rotuj logo nekde kolem stredu
		float alpha = 0;
		float radius = 80;
		int x;
		int y;
		while (true) {
			while (goes) {
				x = (int) (radius * Math.cos(alpha)) + 100;
				y = (int) (radius * Math.sin(alpha)) + 90;
				mPicture.setLocation(x,y);
				alpha += 0.01f;
				try { Thread.sleep(10); }
				catch (InterruptedException e) {;}
			}
		}
	}
	
	private Image loadLogo() {
		return this.getImage(this.getCodeBase(),"images/javalogo.gif");
  		
	}
	
	private Image loadBackground() {
		return this.getImage(this.getCodeBase(),"images/ground.gif");
		
	}
	
	class MyActionListner implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			goes = !goes;
		}
	}
}

// pro appletviewer :
//
// <APPLET code="demo.DemoApplet.class" WIDTH = 400 HEIGHT = 400></APPLET>
//
//