/**
* @author Vclav Mikolek
* nicklaus@students.zcu.cz
*/

package animace.label;

import animace.*;
import javax.swing.*;
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;

/**
 * TestLabel ukazuje pouit pipravench td PictureLabel a MoveablePicture
 * Vimte si, jak se v metod initPictures() registruje poslucha udalost, 
 * kter reprezentuje kliknut na MoveablePicture. Je to stejn postup jako
 * u standardnch AWT.Component.
 */
public class TestLabel {
	private static JFrame frame;
	private static PictureLabel scr;
	private static MoveablePicture[] mPictures = new MoveablePicture[0];
	
	/**
	 * Rozebhne test
	 */
	public static void main(String[] args) {
		if (args.length > 0) {
			try {
				mPictures = new MoveablePicture[Integer.valueOf(args[0]).intValue()];
			}
			catch (NumberFormatException e) {
				System.out.println("Parametrem je pocet obrazku");
				System.exit(1);
			}
		}
		initFrame();
		initPictures();
		frame.setVisible(true);
	}
	
	/**
	 * Inicializan metoda pro okno a obrzky. Obrzek na pozad se tah z ImageSource
	 */
	private static void initFrame() {
		frame = new JFrame("Test PictureLabelu - vlastni obrazky");
		
		JTextArea napoveda = new JTextArea();
		napoveda.setFont(new Font("Arial Bold", Font.PLAIN,12));
		napoveda.setBorder( new javax.swing.plaf.BorderUIResource.BevelBorderUIResource(1));
		napoveda.setEditable(false);
		napoveda.setText(" Npovda:\n"+
				 " Stisknutm klves F1 az F12 uvedete do pohybu nebo zastavte\n" +
				 " obrzky s odpovdajcm poadovm slem. Kliknutm na konkrtn\n"+
				 " obrzek zobrazte oknko s daji o jeho slu, FPS,\n"+
				 " celkovm potu snmku a potu posun");
		
		/// Obrazek na pozadi :
		BufferedImage bg = ImageSource.square1(Color.red.darker(),Color.red.darker().darker());
		
		/// PictureLabel :
		scr = new PictureLabel(bg);
		
		///nastaveni okna
 		Container c = frame.getContentPane();  
		c.setLayout(new BorderLayout());
		c.add(scr,BorderLayout.CENTER);
		c.add(napoveda,BorderLayout.SOUTH);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setSize(400,450);
		scr.setPreferredSize(new Dimension(400,400));
                frame.setLocation(100, 0);
	}
	
	/**
	 * Vytvo instance tdy MoveablePicture, zaregistruje jim posluchae na kliknut
	 * a d je na PictureLabel.
	 */
	private static void initPictures() {
		for (int i = 0; i < mPictures.length; i++) {
			mPictures[i] = new MoveablePicture(scr,ImageSource.javaLogo());
			mPictures[i].setPaintControl(new PaintControl());
			///
			/// ZDE SI ZAREGISTRUJEME POSLUCHACE :
			///
			mPictures[i].addActionListener(new MPictureActionListener("F"+(i+1)));
			
			/// dame MoveablePicture na PicturePanel
			scr.addMoveablePicture(mPictures[i]);
			scr.getInputMap(scr.WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke(KeyEvent.VK_F1 + i,0),"F"+(i+1));
			scr.getActionMap().put("F"+(i+1),new MoveablePictureKeyAction(mPictures[i]));
		}
		scr.doMPLayout();
	}
	
	/**
	 * AbstractAction starajc se o rozbhnut poadovanho obrzku
	 * po stisku klvesy F1 az F12, podle potu obrzku.
	 */
	public static class MoveablePictureKeyAction extends AbstractAction {
		private MoveablePicture mp = null;
		private Driver driver = null;
		
		/**
		 * Konstruktor vyaduje objekt typu MoveablePicture
		 * pro kter bude vytvet vlkno Driver
		 */
		public MoveablePictureKeyAction(MoveablePicture mp) {
			this.mp = mp;
		}
		
		/**
		 * Po stisku klvesy F(X) se provede test, zda je objekt ji v pohybu,
		 * potom je pozastaven, v opanm ppad se inicializuje vlkno Driver
		 * pro tento objekt a je sputno.
		 */
		public void actionPerformed(ActionEvent e) {
			if (driver != null && driver.goes()) {
				driver.stopDriving();
			}
			else {
				PictureLabel c = (PictureLabel) e.getSource();
				driver = new Driver(mp,0,0,c.getWidth() - mp.getWidth(),c.getHeight()-mp.getHeight());
				driver.setPaintControl(((PaintControled) mp).getPaintControl());
				driver.start();
			}
		}
	}
	
	/**
	 * MPictureActionListener zpsob, e po kliknut na MoveablePicture
	 * bude oteveno okno s nktermi informacemi o objektu.
	 */
	public static class MPictureActionListener implements ActionListener {
		private JFrame infoFrame = null;
		private JLabel nameVal;
		private JLabel name		= new JLabel(" Tlacitko:",JLabel.LEFT);;
		private JLabel fps 	 	= new JLabel(" FPS:",JLabel.LEFT);
		private JLabel frames 	 	= new JLabel(" Snimku:",JLabel.LEFT);
		private JLabel movesCount 	= new JLabel(" Posun o:",JLabel.LEFT);
		private JLabel movesCountNum 	= new JLabel("",JLabel.LEFT);
		private JLabel fpsNum 	 	= new JLabel("",JLabel.LEFT);
		private JLabel framesNum 	= new JLabel("",JLabel.LEFT);
			
				
			
		public MPictureActionListener(String name) {
			this.nameVal = new JLabel(" " + name, JLabel.LEFT);
			initInfoFrame();
		}
		
		/// Nastavi podobu okna
		private void initInfoFrame() {
			infoFrame = new JFrame();
			Container c = infoFrame.getContentPane();
			c.setLayout(new GridLayout(0,2));
			c.add(name);
			c.add(nameVal);
			c.add(fps);
			c.add(fpsNum);
			c.add(frames);
			c.add(framesNum);
			c.add(movesCount);
			c.add(movesCountNum);
			
			c.setBackground(Color.gray.brighter());
		}
		
		/**
		 * Kdy uivatel klikne na MoveablePicture, provede se tato obsluha, kter
		 * oteve okno s nktermi informacemi o objektu. Jmno, FPS, Poet snmk a poet
		 * vykonanch posun.
		 */
		public void actionPerformed(ActionEvent e) 
		{
			
			MoveablePicture mp = (MoveablePicture) e.getSource();
			
			fpsNum.setText(" " + Math.round(mp.getPaintControl().getAverageFps()));
			framesNum.setText(" " + mp.getPaintControl().framesCount);
			movesCountNum.setText(" " + mp.getPaintControl().movesCount);
			infoFrame.pack();
			if (infoFrame.isVisible()) {
 				infoFrame.validate();  
			}
			else {
				infoFrame.setVisible(true);
			}
		}
	}
}