/**
* @author Vclav Mikolek
* nicklaus@students.zcu.cz
*/

package animace.panel;

import animace.*;
import javax.swing.*;
import javax.imageio.*;
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;

/**
 * PicturePanel je vlastn jenom JLayeredPane, s nastavenm obrzkem na pozad. Viz metoda paintComponent()
 * Protoe se pedpoklda, e bude mt i objetky implementujic rozhran PaintControled
 * je pretena metoda paint(), tak aby zavolala objectPainted() a metoda add(), tak
 * abychom zskali kontrolu nad tmito objekty.
 * Jinak se PicturePanel od JLayeredPaneu prakticky neli.
 */

public class PicturePanel extends JLayeredPane {
	private BufferedImage background;
	private ArrayList controledObjects = new ArrayList();
	private PaintControl pc = new PaintControl();
	
	/**
	 * Vytvo PicturePanel s obrzkem na pozad
	 * @param background obrzek, kter bude na pozad PicturePanelu
	 */		
	public PicturePanel(BufferedImage background) {
		this.background = background;
		init();
	}
	
	/**
	 * Vytvo PicturePanel bez obrzku. 
	 */
	public PicturePanel() {
		this.background = null;
		init();
	}

	/**
	 * Nedl nic jinho, ne e pokud je nastaven obrzek pozad, tak jej
	 * nakresl.
	 */
	public void paintComponent(Graphics g) 
	{
		if (background != null)
			g.drawImage(background,0,0,null);
		else {
			g.setColor(Color.white);
			g.fillRect(0, 0, getWidth(), getHeight());
		}
	}

	/**
	 * Vol rovnou <tt>super.paint</tt>,a pot "ekne" vem PaintControled objektm,
	 * e byly nakresleny, to se porvede volnm metody objectPainted() nad jejich paintControlery. 
	 */
	public void paint(Graphics g) {
		super.paint(g);
		for(Iterator it = controledObjects.iterator(); it.hasNext(); ((PaintControled)it.next()).getPaintControl().objectPainted());
	}

	/**
	 * Inicializace PicturePanelu, nastav layout na FlowLayout, bez eho
	 * by se vbec nic nezobrazilo. A nastav hodnotu opaque na true,
	 * protoe obrzek na pozad nen prhledn a doshneme tm urychlen.
	 */
	public void init() {
		setLayout(new FlowLayout());
		setOpaque(true);
	}
	
	/**
	 * Pekryt zdden metody add(Componnet c, int num), abychom zskali kontrolu nad objekty, kter
	 * jsou PaintControled
	 */
	public void add(Component c, Object num) {
		if (c instanceof PaintControled) {
			controledObjects.add(c);
		}
		super.add(c,num);
	}
	
	/**
	 *  Nastav obrzek pozad na <tt>background</tt>
	 */
	public void setBackground(BufferedImage background) {
		this.background = background;
	}
}