/**
* @author Vclav Mikolek
* nicklaus@students.zcu.cz
*/

package animace;

import javax.swing.*;
import java.awt.*;
import java.awt.image.*;
import java.util.*;

/**
 * Tda Driver poskytuje vlkno, kter m za kol pohybovat
 * s jednm objektem typu Moveable. Priem umouje pouit
 * PaintControleru, kter zaruuje, e s objektem nen proveden
 * dali pohyb, dokud nen star pozice objektu vykreslena
 */
public class Driver extends Thread {
	private Moveable object;		// s timto objektem se bude pohybovat
	private float step 	= 1f;		// znamena o kolik pixelu se posouva za jedno kolo
	private float stepCount	= 0f;		// znamena o kolik pixelu se jiz pohnul;
	private float dirX 	= -1f;		// dirX a dirY urcuji, kterym smerem se objekt pohybuje
	private float dirY 	= 1f;		
	private int locationX 	= 0;		// souradnice pozice obdelniku, ve kterem se muze objekt pohybovat
	private int locationY 	= 0;			
	private int width 	= 0;		// rozmer oblasti, ve ktere se objekt pohybuje
	private int height 	= 0;		
	private boolean goes 	= false;	// zda jede nebo stoji
	private long time 	= -1;	
	private PaintControl pc = null;		// PaintControl pc
			
	/**
	* Vytvo idie pro objekt implemenujic rozhran Moveable. Objekt se bude pohybovat
	* v obdelnku urenm parametry locationX, locationY (umstni), width a height
	* @param object Moveable objekt, s kterm bude Driver lomcovat.
	* @param locationX ukotven na ose x oblasti (obdlnku), ve kterm se objekt pohybuje.
	* @param locationY ukotven te oblasti na ose y.
	* @param width ka oblasti.
	* @param height vka oblasti.
	*/
	public Driver(Moveable object,int locationX,int locationY,int width,int height) { 
		this.object = object;
		this.locationX = locationX;
		this.locationY = locationY;
		this.width = width;
		this.height = height;
	}
	
	/**
 	* Touto metodou lze uvst "Drivera" do pohybu
	*/
	public void start() {
		this.goes = true;
		super.start();
	}
	
	/**
	 * Podav informaci o stavu idie.
	 */
	public boolean goes() {
		return goes;
	}
	/**
	 * Zastav idie
	 */
	public void stopDriving() {
  		goes = false;    
	}
	/**
	 * Vrac daj o tom, jak dlouho vlkno belo.
	 */
	public long getTime() {
		return time;
	}

	/**
	 * Nastav smr jakm se bude objekt pohybovat, maj smysl pouze cel sla, protoe
	 * location se uchovv v celch slech.
	 */
	public void setDir(float dirX, float dirY) {
		this.dirX = dirX;
		this.dirY = dirY;
	}

	/**
	 * Program bhu vlkna. Vlkno se rozebhne a be dokud jej njak jin vlkno
	 * nezastav volnm <tt>stopDriving()</tt> nebo a se objekt 5000x posune.
	 */ 
	public synchronized void run() {
		stepCount = 0;
		step = 1f;
		long timeAtStart = System.currentTimeMillis();
		
		/// zacni pocitat fps
		if (pc != null) {
			pc.fps(true);
		}
		while (goes && stepCount < 5000) {
			move();
			stepCount++;
			if (pc != null) {
				pc.objectMoved();
			}
			else {
				try { sleep(10);}
				catch (InterruptedException e) {;}
			}
		}
		goes = false;
		/// kdyz dobehl, uz nepocitej FPS
		if (pc != null) {
			pc.fps(false);
		}
		long timeAtStop = System.currentTimeMillis();
		this.time = timeAtStop - timeAtStart;
	}
	
	/**
	 * Tato metoda implementuje jednoduch algoritmus pohybu
	 * pohne s objektem, vdy pouze o jeden "step", implicitn nastaven na 1 pixel
	 */
	private void move() {
		Point location = object.getLocation();
		if (location.x < locationX - (step * dirX)) {
			dirX = Math.abs(dirX);
		}
		if (location.x > width - (step * dirX)) {
			dirX = -Math.abs(dirX);
		}
		if (location.y < locationY - (step * dirY)) {
			dirY = Math.abs(dirY);
		}
		if (location.y > height - (step * dirY)) {
			dirY = -Math.abs(dirY);
		}
		
		object.setLocation(Math.round(location.x +  (dirX * step)), Math.round(location.y + (dirY * step)));
	}
	
	/**
	 * Umon nastavit kontrolu, kter se start o prbh vykreslovn objektu
	 */
	public void setPaintControl(PaintControl pc) {
		this.pc = pc;
	}
}
