/**
* @author Vclav Mikolek
* nicklaus@students.zcu.cz
*/

package animace.panel;

import animace.*;
import javax.swing.*;
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;

/**
 * Tda TestPanel ukazuje pouit pipravench td PicturePanel a PictureButton.
 * Vzhledem k tomu, e ob tdy nejsou nic jinho, ne potomky tdy ze Swingu, 
 * potamo z AWT, je jejich pouit snadn a zcela standardn. V tomto systmu, kdy
 * JButtony nesou obrzky a jsou umstny na panel (s obrzkem na pozad) mme velice
 * mlo prce s implementac.
 */
public class TestPanel {
	private static JFrame frame;
	private static PicturePanel scr;
	private static PictureButton[] pButtons = new PictureButton[0];
		
	/**
	 * Rozebhne test
	 */
	public static void main(String[] args) {
		if (args.length > 0) {
			try {
				pButtons = new PictureButton[Integer.valueOf(args[0]).intValue()];
			}
			catch (NumberFormatException e) {
				System.out.println("Parametrem aplikace je pocet obrazku");
				System.exit(1);
			}
		}
		
		initFrame();
		initPictures();
		frame.setVisible(true);
	}
	
	/**
	 * Inicializan metoda pro okno a obrzky. Obrzek na pozadi se tah z ImageSource
	 */
	private static void initFrame() {
		frame = new JFrame("Test PicturePanelu - obrazky na buttonech");
		JTextArea napoveda = new JTextArea();
		napoveda.setFont(new Font("Arial Bold", Font.PLAIN,12));
		napoveda.setBorder( new javax.swing.plaf.BorderUIResource.BevelBorderUIResource(1));
		napoveda.setEditable(false);
		napoveda.setText(" Npovda:\n"+
			" Stisknutm klves F1 az F12 uvedete do pohybu nebo zastavte\n" +
			" obrzky s odpovdajcm poadovm slem. Kliknutm na konkrtn\n"+
			" obrzek zobrazte oknko s daji o jeho slu, FPS,\n"+
			" celkovm potu snmku a potu posun");

		
		BufferedImage bg = ImageSource.square1(Color.red.darker(),Color.red.darker().darker());
		
		/// PicturePanel
		scr = new PicturePanel(bg);
		
		///nastaveni okna
		Container c = frame.getContentPane();
		c.setLayout(new BorderLayout());
		c.add(scr,BorderLayout.CENTER);
		c.add(napoveda,BorderLayout.SOUTH);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setSize(400,450);
                frame.setLocation(100, 0);
	}
	
	/**
	 * Vytvo instance tdy PictureButton, zaregistruje jim posluchae kliknut
	 * a d je na PicturePanel.
	 */
	private static void initPictures() {
		/// nastaveni PicturePanelu
		for (int i =0; i < pButtons.length; i++) 
		{
			pButtons[i] = new PictureButton(ImageSource.javaLogo());
			pButtons[i].setPaintControl(new PaintControl());
			pButtons[i].addActionListener(new PButtonActionListener("F"+(i+1)));
			scr.add(pButtons[i],JLayeredPane.DEFAULT_LAYER);
			scr.getInputMap(scr.WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke(KeyEvent.VK_F1 + i,0),"F"+(i+1));
			scr.getActionMap().put("F"+(i+1),new PButtonKeyAction(pButtons[i]));
		}
	}
	
	/**
	 * AbstractAction (Reakce na stik klvesy) starajic se o rozbhnut poadovanho obrzku
	 */
	public static class PButtonKeyAction extends AbstractAction {
		private PictureButton pb = null;
		private Driver driver = null;

			
		/**
		 * Konstruktor vyaduje objekt typu PictureButton,
		 * pro kter bude vytvet vlkno Driver
		 */
		public PButtonKeyAction(PictureButton pb) {
			this.pb = pb;
		}
		
		/**
		 * Po stisku klvesy F(X) se provede test, zda je objekt ji v pohybu,
		 * potom je pozastaven, v opanm ppad se inicializuje vlkno Driver
		 * pro tento objekt a je sputno.
		 */
		public void actionPerformed(ActionEvent e) {
			if (driver != null && driver.goes()) {
				driver.stopDriving();
			}
			else {
				PicturePanel c = (PicturePanel) e.getSource();
				driver = new Driver(pb,0,0,c.getWidth() - pb.getWidth(),c.getHeight()-pb.getHeight());
				driver.setPaintControl(pb.getPaintControl());
				driver.start();
			}
		}
	}
	
	/**
	 * PButtonActionListener zpsob, e po kliknuti na PictureButton 
	 * bude oteveno okno s nktermi informacemi o objektu.
	 */
	public static class PButtonActionListener implements ActionListener {
		private JFrame infoFrame = null;
		private JLabel nameVal;
		private JLabel name		= new JLabel(" Tlacitko:",JLabel.LEFT);;
		private JLabel fps 	 	= new JLabel(" FPS:",JLabel.LEFT);
		private JLabel frames 	 	= new JLabel(" Snimku:",JLabel.LEFT);
		private JLabel movesCount 	= new JLabel(" Posun o:",JLabel.LEFT);
		private JLabel movesCountNum 	= new JLabel("",JLabel.LEFT);
		private JLabel fpsNum 	 	= new JLabel("",JLabel.LEFT);
		private JLabel framesNum 	= new JLabel("",JLabel.LEFT);
			
				
		/**
		 * Konstruktor vyaduje jmno objektu, tento parametr se potom zobraz 
		 * mezi informacemi.
		 */	
		public PButtonActionListener(String name) {
			this.nameVal = new JLabel(" " + name, JLabel.LEFT);
			initInfoFrame();
		}
		
		/// Nastavi podobu okna
		private void initInfoFrame() {
			infoFrame = new JFrame();
			Container c = infoFrame.getContentPane();
			c.setLayout(new GridLayout(0,2));
			c.add(name);
			c.add(nameVal);
			c.add(fps);
			c.add(fpsNum);
			c.add(frames);
			c.add(framesNum);
			c.add(movesCount);
			c.add(movesCountNum);
			
			c.setBackground(Color.gray.brighter());
		}

		/**
		 * Kdy uivatel klikne na PictureButton, provede se tato obsluha, kter
		 * oteve okno s nktermi informacemi o objektu. Jmno, FPS, Poet snmk a poet
		 * vykonanch posun.
		 */
		public void actionPerformed(ActionEvent e) {
			
			PictureButton pb = (PictureButton) e.getSource();
			
			fpsNum.setText(" " + Math.round(pb.getPaintControl().getAverageFps()));
			framesNum.setText(" " + pb.getPaintControl().framesCount);
			movesCountNum.setText(" " + pb.getPaintControl().movesCount);
			infoFrame.pack();
			if (infoFrame.isVisible()) {
 				infoFrame.validate();  
			}
			else {
				infoFrame.setVisible(true);
			}
		}
	}
}