/**
* @author Vclav Mikolek
* nicklaus@students.zcu.cz
*/

package animace.label;

import animace.*;
import javax.swing.*;
import javax.imageio.*;
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;

/**
 * PictureLabel je potomkem tdy JLabel, umouje umsovat
 * objekty tdy MoveablePicture a star se o to, aby byly vkresleny
 * Viz metoda paintComponent. Pokud uivatel klikne na PictureLabel, je
 * zajitno obsluhou teto udlosti, e kliknul-li na njak MoveablePicture,
 * je mu tato udlost distribuovna (volanm processEvent(e)).
 */
 public class PictureLabel extends JLabel {
	
	private BufferedImage background;
				
	private ArrayList mPictures = new ArrayList();		// MoveablePicture List
	private Iterator it;

	/**
	 * Vytvo PictureLabel s obrzkem na pozad
	 * @param background obrzek, kter pjde na pozad
	 */
	public PictureLabel(BufferedImage background) {
		this.background = background;
		init();
	}

	/**
	 * Vytvo PictureLabel bez obrzku.
	 */
	public PictureLabel() {
		this.background = null;
		init();
	}
	
	/**
	 * Inicializan metoda nastav opaque na true. Tm urychlme vykreslovn.
	 * Pedpokld se ovem e obrzek na pozad je neprhledn. Pozor! Volnm
	 * setOpaque(true) nezpsobme neprhlednost PictureLabelu, jen ekneme, e je neprhledn
	 * a o to, aby doopravdy byl, se musme postarat sami.  Protoe ddme od
	 * JLabelu, kter je implictin prhledn : isOpaque() vrac false, je toto voln nezbytn.
	 */
	public void init() {
		setOpaque(true); // DULEZITE !
		addMouseListener(new ClickListener());
	}
		
	/**
	 * Vykresl obrzek na pozad a potom vol metodu paint(Graphics g) nad vemi svmi
	 * MoveablePictures a nad kadm jeho PaintControlerem jet vol objectPainted();
	 */
	public void paintComponent(Graphics g) {
			
		if (background != null)
			g.drawImage(background,0,0,null);
		else {
			g.setColor(Color.white);
			g.fillRect(0,0,getWidth(),getHeight());
		}
		
		it = mPictures.iterator();
		while(it.hasNext()) {
			MoveablePicture mp = (MoveablePicture) it.next();
			mp.paint(g);
			mp.getPaintControl().objectPainted();
			
		}
	}
	
	/**
	 * Touto metodou pidvme pohybliv obrzky na PictureLabel
	 */
	public void addMoveablePicture(MoveablePicture mp){
		mPictures.add(mp);
	}
	
	/**
	 * doMPLayout romzisti vsechny MoveablePictures do jakehosi grid layoutu
	 * Tady je to spise pomocna metoda.
	 */
	public void doMPLayout() {
		int perRow	= 7;	 	// pocet MPictures na jedne radce
		int xGap	= 10;		// odsazeni na ose x
		int yGap	= 5;		// odsazeni na ose y
		Iterator it = mPictures.iterator();
		for(int i = 0; it.hasNext(); i++) {
			MoveablePicture mp = (MoveablePicture) it.next();
			mp.setLocation((i%perRow)*(mp.getWidth() + xGap) + (getPreferredSize().width - (perRow * (mp.getWidth() + xGap))) / 2, i / perRow * (mp.getHeight()+ yGap));
		}
	}
	
	/**
	 * Vnitn tda, kter implementuje MouseListener (dd od MouseAdapter)
	 * a zajiuje, e kliknut nad touto komponentou (JLabelem) bude poslno dl
	 * jestlie se uskutenilo nad njakm MoveablePicturem. Tm, e prochzm
	 * seznam mPictures v opanm poad ne jsou objekty vykreslovny, rem to, kter  
	 * objekt le nad kterm, take se neme stt, e bude volna metoda processEvent
	 * nad objektem, kter le vespod.
	 */
	public class ClickListener extends MouseAdapter {
		public void mouseClicked(MouseEvent e) {
			MoveablePicture mp;
			boolean oneHasBeenClicked = false;
			
			Point click = e.getPoint();
			ListIterator lit = mPictures.listIterator(mPictures.size());
			while(lit.hasPrevious()) {
				mp = (MoveablePicture) lit.previous();
				if (mp.contains(click)) {
					mp.processEvent(e);
					oneHasBeenClicked = true;
					break;
				}
			}
			
			/// jeslize se nekliklo na MoveablePicture, tak s kliknutim nalozte
			/// jak chcete
			if (!oneHasBeenClicked) {
				//
				// Tady muze byt obsluha, kterou chceme 
				// provest primo nad PictureLabelem
				//
			}
		}
	}
}