/**
* @author Vclav Mikolek
* nicklaus@students.zcu.cz
*/

package animace.panel;

import animace.*;
import javax.swing.*;
import javax.imageio.*;
import java.awt.*;
import java.awt.image.*;
import java.io.*;

/**
 * Tda PictureButton umouje vytvorit tlatko s libovolnou grafickou
 * podobou. Pokud se divte, e nikde neimplementuje metody z rozhran Moveable
 * tak je to proto, e dd od JButtonu, kde jsou tyto metody ji naimplementovany
 */
public class PictureButton extends JButton implements Moveable, PaintControled {
	private BufferedImage img;
	private PaintControl pc = null;
	
	
	/**
	 * Konstruktor vytvo tlatko s obrzkem.
	 * @param img obrazek, kter nahrad implicitn grafickou podobu tlatka
	 */
	public PictureButton(BufferedImage img) {
		this.img = img;
		init();
		
	
	}
	private void init() {
		setBorder(null);		//aby nemel obrazek oramovani, ktere je impicitne u JButtonu nastevno
		setOpaque(false);		//DULEZITE - opet implictine nastaveno na true, nutne zmenit (u JButtonu), aby nevznikal za PictureButtonem "neporadek"
		setPreferredSize(new Dimension(img.getWidth(),img.getHeight())); 
	}
	
	/**
	 * U Swing komponent je nevhodne pekrvat metodu paint(Graphics g). Grafickou podobu tlatka
	 * nastavme v metod paintComponent(Graphics g);
	 */
	public void paintComponent(Graphics g) {
		g.drawImage(img,0,0,img.getWidth(),img.getHeight(),null);
	}
	
	/**
	 * Metoda z rozhran PaintControled
	 */
	public void setPaintControl(PaintControl pc) {
		this.pc = pc;
	}
	
	/**
	 * Metoda z rozhran PaintControled
	 */
	public PaintControl getPaintControl() {
		return pc;
	}
}