/**
* @author Vclav Mikolek
* nicklaus@students.zcu.cz
*/

package animace;

import java.util.*;

/**
 * Tato tda slou ke kontrole kreslen rznch objekt, me mrit jak
 * asto jsou tyto objekty pekreslovny (fps).
 * Metody <tt>objectMoved</tt> a <tt>objectPainted</tt> jsou synchronizovan, protoe se
 * pedpoklda, e pohyb objektu a jeho vykreslovn jsou zeny rznmi vlkny.
 * Potom PaintControl zad, e se s objektem nepohne dve, dokud nen jeho 
 * pozice tak nakreslena.
 */

public class PaintControl {

	/**
	 * painted, kontroln podmnkov promnn. Z vnjku by se nemla mnit
	 * jinak, ne pes metody <tt>objectMoved</tt> a <tt>objectPainted</tt>,
	 * Nen dvod por by nemohla bt <b><tt>private</tt></b>. :-)
	 */
	public boolean painted = false;
	/**
	 * Poet snmk = poet zavoln metody <tt>objectPainted</tt>.
	 */
	public int framesCount = 0;
	/**
	 *  poet pohyb  = poet zavoln metody <tt>objectMoved</tt>,
	 */
	public int movesCount = 0;

	private boolean fpsOn = false;
	private double fps = 0;
	private double averageFps = 0;
	private long timeLast = 0;
	private long timeFirst = 0;
	private long timeFirstMillis = 0;
	private long timeStopedMillis = 0;
	private double maxFps = 0;
	private double minFps = Double.MAX_VALUE;
		
	/**
	 * Kdy se s objektem pohne a je zavolna tato metoda, pozastav se vlkno a ek,
	 * ne vlkno kter se star o vykreslovn zavol metodu objectPainted().
	 */
	public synchronized void objectMoved() {
		movesCount++;
		while (!painted)
			try {
				wait();
			}
			catch (InterruptedException e) {;}
		painted = false;
	}

	/**
	 * Tato metoda vzbud ppadn vlkno, kter ekalo, ne
	 * je objekt znovu pekereslen.
	 */
	public synchronized void objectPainted() {
		if (fpsOn) {
			countFps();
		}
		if (!painted){
			painted = true;
			notifyAll();
		}
	}
	
	/**
	 * Pot FPS, jak aktuln, tak i prmrn. Pro akutln FPS je nutn pout metodu
	 * System.nanoTime(), kter je v SDK od verze SDK 1.5 odkomentujte text, v ppade, e
	 * pouzivate tuto verzi nebo vy.
	 */
	public double countFps() {
		if (timeFirstMillis == 0)
			timeFirstMillis = System.currentTimeMillis();	
		/* od verze SDK 1.5
		if (timeLast == 0)
			timeLast = System.nanoTime();	
		if (timeFirst == 0)
			timeFirst = System.nanoTime();	
		*/
		else {
			averageFps = (1000d*framesCount/(System.currentTimeMillis() - timeFirstMillis));
			/* od verze SDK 1.5
			long timeNow = System.nanoTime();
			fps = 1000000000d / (timeNow - timeLast);
				maxFps = fps > maxFps ? fps : maxFps;
			minFps = fps < minFps ? fps : minFps;
			timeLast = timeNow;
			*/
			framesCount++;
		}
		return fps;
	}
	
	/**
	 * Nastav, zda bude PaintControl potat, jak asto je objekt pekreslovn
	 */
	public void fps(boolean val) {
		fpsOn = val;
		/// jestlize bylo pocitani rozbehnuto, resetuj stav
		if (fpsOn) {
			timeLast  	= 0;
			timeFirst 	= 0;
			timeFirstMillis = System.currentTimeMillis();
			framesCount	= 0;
			movesCount	= 0;
		}
	}
	/**
	 * Vrac aktuln FPS
	 */
	public double getFps() {
		return fps;
	}

	/**
	 * Vrac prmrn FPS od doby kdy bylo zapnuto potn metodou
	 * <tt>fps(true)</tt> do doby ne je opt vypnuto.
	 */
	public double getAverageFps() {
		return averageFps;
	}
	/**
	 * Vrac maximln FPS
	 */
	public double getMaxFps() {
		return maxFps;
	}
	/**
	 * Vrac minimln FPS
	 */
	public double getMinFps() {
		return minFps;
	}
}