/**
* @author Vclav Mikolek
* nicklaus@students.zcu.cz
*/

package animace;

import java.awt.*;
import java.awt.image.*;
import java.io.*; 
import javax.imageio.*;

/**
 * Tda ImageSource, zajiuje, e pouit obrzky budou v obou testech shodn -
 * pro zajitni jednotnho pstupu a objektivity testovni.
 */
public class ImageSource {
	public static BufferedImage square1(Color c1,Color c2) {
		BufferedImage bim = new BufferedImage(5000,5000,BufferedImage.TYPE_BYTE_INDEXED);
		Graphics g = bim.getGraphics();
		g.setClip(0,0,bim.getWidth(),bim.getHeight());
		drawSquares(g,c1,c2,0,0);
		return bim;
	}

	/**
	 * Vrac obrzek koucho lku (java logo), kter je naten ze souboru.
	 */
	public static BufferedImage javaLogo() {
		BufferedImage img = null;
		try {
			img = ImageIO.read(new File("images/javalogo.gif"));
		}
		catch (IOException e ) {
			e.printStackTrace();
		}
		return img;
	}
	
	/**
	 * Kresl tvereky (achovnici) v barvch c1 a c2 od pozice x,y.
	 * @param x,y urcuji souadnici hornho levho rohu achovnice, kter se umsti do hornho rohu (0,0) grafickho objektu
	 * jde vlastn o posunut achovnice
	 */
	public static void drawSquares(Graphics g,Color c1, Color c2, int x, int y) {
		int width = g.getClipBounds().width;
		int height = g.getClipBounds().height;
		g.setColor(c1);
		g.fillRect(0,0,width, height);
		
		g.setColor(c2);

		int squareWidth = 30; 
		int squareHeight = 30; 
		for (int i = 0; i * squareWidth < width;i++) {
			for (int j = 0;j * squareHeight < height;j++) {
				if ((i+j) % 2 == 0) {
					g.fillRect(i * squareWidth - x,j * squareHeight - y,squareWidth,squareHeight);
				}
			}
		}
	}
}