/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.undo;

import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class CompoundEdit
extends AbstractUndoableEdit {
    protected Vector edits;
    private boolean inProgress;

    private /* synthetic */ void finit$() {
        this.edits = new Vector();
        this.inProgress = false;
    }

    public CompoundEdit() {
        this.finit$();
    }

    public boolean addEdit(UndoableEdit anEdit) {
        if (this.inProgress) {
            UndoableEdit lastEdit = this.lastEdit();
            if (lastEdit != null && !lastEdit.addEdit(anEdit) && !lastEdit.replaceEdit(anEdit)) {
                this.edits.add(anEdit);
            }
            return true;
        }
        return false;
    }

    public boolean canRedo() {
        return !this.isInProgress() && super.canRedo();
    }

    public boolean canUndo() {
        return !this.isInProgress() && super.canUndo();
    }

    public void die() {
        for (int index = this.edits.size() - 1; index >= 0; --index) {
            UndoableEdit current = (UndoableEdit)this.edits.elementAt(index);
            current.die();
        }
    }

    public void end() {
        this.inProgress = false;
    }

    public String getPresentationName() {
        if (this.edits.size() == 0) {
            return super.getPresentationName();
        }
        return this.lastEdit().getPresentationName();
    }

    public String getRedoPresentationName() {
        if (this.edits.size() == 0) {
            return super.getRedoPresentationName();
        }
        return this.lastEdit().getRedoPresentationName();
    }

    public String getUndoPresentationName() {
        if (this.edits.size() == 0) {
            return super.getUndoPresentationName();
        }
        return this.lastEdit().getUndoPresentationName();
    }

    public boolean isInProgress() {
        return this.inProgress;
    }

    public boolean isSignificant() {
        for (int index = 0; index < this.edits.size(); ++index) {
            UndoableEdit current = (UndoableEdit)this.edits.elementAt(index);
            if (!current.isSignificant()) continue;
            return true;
        }
        return false;
    }

    protected UndoableEdit lastEdit() {
        if (this.edits.size() == 0) {
            return null;
        }
        return (UndoableEdit)this.edits.elementAt(this.edits.size() - 1);
    }

    public void redo() throws CannotRedoException {
        for (int index = 0; index < this.edits.size(); ++index) {
            UndoableEdit current = (UndoableEdit)this.edits.elementAt(index);
            current.redo();
        }
    }

    public String toString() {
        return null;
    }

    public void undo() throws CannotUndoException {
        for (int index = this.edits.size() - 1; index >= 0; --index) {
            UndoableEdit current = (UndoableEdit)this.edits.elementAt(index);
            current.undo();
        }
    }
}

