/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import gnu.gcj.io.MimeTypes;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ContentHandler;
import java.net.ContentHandlerFactory;
import java.net.FileNameMap;
import java.net.URL;
import java.net.UnknownServiceException;
import java.security.AllPermission;
import java.security.Permission;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class URLConnection {
    protected URL url;
    protected boolean doInput;
    protected boolean doOutput;
    protected boolean allowUserInteraction;
    protected boolean useCaches;
    protected long ifModifiedSince;
    protected boolean connected;
    private static boolean defaultAllowUserInteraction = false;
    private static boolean defaultUseCaches = true;
    private static FileNameMap fileNameMap;
    private static ContentHandlerFactory factory;
    private static ContentHandler contentHandler;
    private static Hashtable handlers;
    private static Locale locale;
    private static SimpleDateFormat dateFormat1;
    private static SimpleDateFormat dateFormat2;
    private static SimpleDateFormat dateFormat3;
    private static boolean dateformats_initialized;

    private /* synthetic */ void finit$() {
        this.doInput = true;
        this.doOutput = false;
        this.ifModifiedSince = 0L;
        this.connected = false;
    }

    protected URLConnection(URL url) {
        this.finit$();
        this.url = url;
        this.allowUserInteraction = defaultAllowUserInteraction;
        this.useCaches = defaultUseCaches;
    }

    public abstract void connect() throws IOException;

    public URL getURL() {
        return this.url;
    }

    public int getContentLength() {
        return this.getHeaderFieldInt("content-length", -1);
    }

    public String getContentType() {
        return this.getHeaderField("content-type");
    }

    public String getContentEncoding() {
        return this.getHeaderField("content-encoding");
    }

    public long getExpiration() {
        return this.getHeaderFieldDate("expiration", 0L);
    }

    public long getDate() {
        return this.getHeaderFieldDate("date", 0L);
    }

    public long getLastModified() {
        return this.getHeaderFieldDate("last-modified", 0L);
    }

    public String getHeaderField(int num) {
        return null;
    }

    public String getHeaderField(String name) {
        return null;
    }

    public Map getHeaderFields() {
        return null;
    }

    public int getHeaderFieldInt(String name, int val) {
        String str = this.getHeaderField(name);
        try {
            if (str != null) {
                val = Integer.parseInt(str);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return val;
    }

    public long getHeaderFieldDate(String name, long val) {
        String str;
        if (!dateformats_initialized) {
            this.initializeDateFormats();
        }
        if ((str = this.getHeaderField(name)) != null) {
            Date date = dateFormat1.parse(str, new ParsePosition(0));
            if (date != null) {
                val = date.getTime();
            } else {
                date = dateFormat2.parse(str, new ParsePosition(0));
                if (date != null) {
                    val = date.getTime();
                } else {
                    date = dateFormat3.parse(str, new ParsePosition(0));
                    if (date != null) {
                        val = date.getTime();
                    }
                }
            }
        }
        return val;
    }

    public String getHeaderFieldKey(int num) {
        return null;
    }

    public Object getContent() throws IOException {
        String cType = this.getContentType();
        contentHandler = this.setContentHandler(cType);
        if (contentHandler == null) {
            return this.getInputStream();
        }
        return contentHandler.getContent(this);
    }

    public Object getContent(Class[] classes) throws IOException {
        return this.getContent();
    }

    public Permission getPermission() throws IOException {
        return new AllPermission();
    }

    public InputStream getInputStream() throws IOException {
        throw new UnknownServiceException("Protocol " + this.url.getProtocol() + " does not support input.");
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnknownServiceException("Protocol " + this.url.getProtocol() + " does not support output.");
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.url.toString();
    }

    public void setDoInput(boolean doinput) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.doInput = doinput;
    }

    public boolean getDoInput() {
        return this.doInput;
    }

    public void setDoOutput(boolean dooutput) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.doOutput = dooutput;
    }

    public boolean getDoOutput() {
        return this.doOutput;
    }

    public void setAllowUserInteraction(boolean allowed) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.allowUserInteraction = allowed;
    }

    public boolean getAllowUserInteraction() {
        return this.allowUserInteraction;
    }

    public static void setDefaultAllowUserInteraction(boolean allowed) {
        defaultAllowUserInteraction = allowed;
    }

    public static boolean getDefaultAllowUserInteraction() {
        return defaultAllowUserInteraction;
    }

    public void setUseCaches(boolean usecaches) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.useCaches = usecaches;
    }

    public boolean getUseCaches() {
        return this.useCaches;
    }

    public void setIfModifiedSince(long ifmodifiedsince) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.ifModifiedSince = ifmodifiedsince;
    }

    public long getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public boolean getDefaultUseCaches() {
        return defaultUseCaches;
    }

    public void setDefaultUseCaches(boolean defaultusecaches) {
        defaultUseCaches = defaultusecaches;
    }

    public void setRequestProperty(String key, String value) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
    }

    public void addRequestProperty(String key, String value) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (this.getRequestProperty(key) == null) {
            this.setRequestProperty(key, value);
        }
    }

    public String getRequestProperty(String key) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        return null;
    }

    public Map getRequestProperties() {
        return null;
    }

    public static void setDefaultRequestProperty(String key, String value) {
    }

    public static String getDefaultRequestProperty(String key) {
        return null;
    }

    public static void setContentHandlerFactory(ContentHandlerFactory fac) {
        if (factory != null) {
            throw new Error("ContentHandlerFactory already set");
        }
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkSetFactory();
        }
        factory = fac;
    }

    public static String guessContentTypeFromName(String fname) {
        String type;
        int dot = fname.lastIndexOf(".");
        if (dot != -1) {
            if (dot == fname.length()) {
                return "application/octet-stream";
            }
            fname = fname.substring(dot + 1);
        }
        if ((type = MimeTypes.getMimeTypeFromExtension(fname)) == null) {
            return "application/octet-stream";
        }
        return type;
    }

    public static String guessContentTypeFromStream(InputStream is) throws IOException {
        is.mark(1024);
        is.reset();
        return null;
    }

    public static FileNameMap getFileNameMap() {
        return fileNameMap;
    }

    public static void setFileNameMap(FileNameMap map) {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkSetFactory();
        }
        fileNameMap = map;
    }

    private ContentHandler setContentHandler(String contentType) {
        if (contentType == null || contentType == "") {
            return null;
        }
        ContentHandler handler = (ContentHandler)handlers.get(contentType);
        if (handler != null) {
            if (handler instanceof ContentHandler) {
                return handler;
            }
            return null;
        }
        if (factory != null) {
            handler = factory.createContentHandler(contentType);
        }
        if (handler == null) {
            String propVal = System.getProperty("java.content.handler.pkgs");
            propVal = propVal == null ? "" : propVal + "|";
            propVal = propVal + "gnu.gcj.content|sun.net.www.content";
            StringTokenizer pkgPrefix = new StringTokenizer(propVal, "|");
            char[] cArray = contentType.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == '/') {
                    cArray[i] = 46;
                    continue;
                }
                if (cArray[i] >= 'A' && cArray[i] <= 'Z' || cArray[i] >= 'a' && cArray[i] <= 'z' || cArray[i] >= '0' && cArray[i] <= '9') continue;
                cArray[i] = 95;
            }
            String contentClass = new String(cArray);
            do {
                String facName = pkgPrefix.nextToken() + "." + contentClass;
                try {
                    handler = (ContentHandler)Class.forName(facName).newInstance();
                }
                catch (Exception e) {
                    // empty catch block
                }
            } while ((handler == null || !(handler instanceof ContentHandler)) && pkgPrefix.hasMoreTokens());
        }
        if (handler != null && handler instanceof ContentHandler) {
            handlers.put(contentType, handler);
            return handler;
        }
        handlers.put(contentType, contentType);
        return null;
    }

    private synchronized void initializeDateFormats() {
        if (dateformats_initialized) {
            return;
        }
        locale = new Locale("En", "Us", "Unix");
        dateFormat1 = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss 'GMT'", locale);
        dateFormat2 = new SimpleDateFormat("EEEE, dd-MMM-yy hh:mm:ss 'GMT'", locale);
        dateFormat3 = new SimpleDateFormat("EEE MMM d hh:mm:ss yyyy", locale);
        dateformats_initialized = true;
    }

    static {
        handlers = new Hashtable();
        dateformats_initialized = false;
    }
}

