/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import gnu.gcj.protocol.core.Handler;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.NetPermission;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class URL
implements Serializable {
    private String protocol;
    private String authority;
    private String host;
    private int port;
    private String file;
    private String ref;
    private int hashCode;
    private transient URLStreamHandler handler;
    private static Hashtable handlers = new Hashtable();
    private static URLStreamHandlerFactory factory;
    private static final long serialVersionUID = -7627629688361524110L;

    private /* synthetic */ void finit$() {
        this.port = -1;
        this.hashCode = 0;
    }

    public URL(String protocol, String host, int port, String file) throws MalformedURLException {
        this(protocol, host, port, file, null);
    }

    public URL(String protocol, String host, String file) throws MalformedURLException {
        this(protocol, host, -1, file, null);
    }

    public URL(String protocol, String host, int port, String file, URLStreamHandler handler) throws MalformedURLException {
        this.finit$();
        if (protocol == null) {
            throw new MalformedURLException("null protocol");
        }
        this.protocol = protocol.toLowerCase();
        if (handler != null) {
            SecurityManager s = System.getSecurityManager();
            if (s != null) {
                s.checkPermission(new NetPermission("specifyStreamHandler"));
            }
            this.handler = handler;
        } else {
            this.handler = URL.getURLStreamHandler(protocol);
        }
        if (this.handler == null) {
            throw new MalformedURLException("Protocol handler not found: " + protocol);
        }
        this.host = host;
        this.port = port;
        this.authority = null;
        int hashAt = file.indexOf(35);
        if (hashAt < 0) {
            this.file = file;
            this.ref = null;
        } else {
            this.file = file.substring(0, hashAt);
            this.ref = file.substring(hashAt + 1);
        }
        this.hashCode = this.hashCode();
    }

    public URL(String spec) throws MalformedURLException {
        this((URL)null, spec, (URLStreamHandler)null);
    }

    public URL(URL context, String spec) throws MalformedURLException {
        this(context, spec, null);
    }

    public URL(URL context, String spec, URLStreamHandler handler) throws MalformedURLException {
        int slash;
        this.finit$();
        int colon = spec.indexOf("://", 1);
        if (colon > 0 && !spec.regionMatches(colon, "://:", 0, 4)) {
            context = null;
        }
        if ((colon = spec.indexOf(58)) > 0 && (colon < (slash = spec.indexOf(47)) || slash < 0)) {
            this.protocol = spec.substring(0, colon).toLowerCase();
            if (context != null && context.protocol.equals(this.protocol)) {
                this.host = context.host;
                this.port = context.port;
                this.file = context.file;
                this.authority = context.authority;
            }
        } else if (context != null) {
            colon = -1;
            this.protocol = context.protocol;
            this.host = context.host;
            this.port = context.port;
            this.file = context.file;
            this.authority = context.authority;
        } else {
            throw new MalformedURLException("Absolute URL required with null context");
        }
        if (handler != null) {
            SecurityManager s = System.getSecurityManager();
            if (s != null) {
                s.checkPermission(new NetPermission("specifyStreamHandler"));
            }
            this.handler = handler;
        } else {
            this.handler = URL.getURLStreamHandler(this.protocol);
        }
        if (this.handler == null) {
            throw new MalformedURLException("Protocol handler not found: " + this.protocol);
        }
        int hashAt = spec.indexOf(35, colon + 1);
        this.handler.parseURL(this, spec, colon + 1, hashAt < 0 ? spec.length() : hashAt);
        if (hashAt >= 0) {
            this.ref = spec.substring(hashAt + 1);
        }
        this.hashCode = this.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof URL)) {
            return false;
        }
        URL uObj = (URL)obj;
        return this.handler.equals(this, uObj);
    }

    public final Object getContent() throws IOException {
        return this.openConnection().getContent();
    }

    public final Object getContent(Class[] classes) throws IOException {
        return this.getContent();
    }

    public String getFile() {
        if (this.file == null) {
            return "";
        }
        return this.file;
    }

    public String getPath() {
        int quest = this.file.indexOf(63);
        if (quest < 0) {
            return this.file;
        }
        return this.file.substring(0, quest);
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getHost() {
        int at;
        int n = at = this.host == null ? -1 : this.host.indexOf(64);
        if (at < 0) {
            return this.host;
        }
        return this.host.substring(at + 1, this.host.length());
    }

    public int getPort() {
        return this.port;
    }

    public int getDefaultPort() {
        return this.handler.getDefaultPort();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getRef() {
        return this.ref;
    }

    public String getUserInfo() {
        int at = this.host.indexOf(64);
        if (at < 0) {
            return null;
        }
        return this.host.substring(0, at);
    }

    public String getQuery() {
        int quest = this.file.indexOf(63);
        if (quest < 0) {
            return null;
        }
        return this.file.substring(quest + 1, this.file.length());
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        return this.handler.hashCode(this);
    }

    public URLConnection openConnection() throws IOException {
        return this.handler.openConnection(this);
    }

    public final InputStream openStream() throws IOException {
        return this.openConnection().getInputStream();
    }

    public boolean sameFile(URL other) {
        return this.handler.sameFile(this, other);
    }

    protected void set(String protocol, String host, int port, String file, String ref) {
        this.handler = URL.getURLStreamHandler(protocol);
        this.protocol = protocol.toLowerCase();
        this.authority = null;
        this.port = port;
        this.host = host;
        this.file = file;
        this.ref = ref;
        this.hashCode = this.hashCode();
    }

    protected void set(String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
        this.handler = URL.getURLStreamHandler(protocol);
        this.protocol = protocol.toLowerCase();
        this.host = userInfo == null ? host : userInfo + "@" + host;
        this.port = port;
        this.file = query == null ? path : path + "?" + query;
        this.ref = ref;
        this.hashCode = this.hashCode();
    }

    public static synchronized void setURLStreamHandlerFactory(URLStreamHandlerFactory fac) {
        if (factory != null) {
            throw new Error("URLStreamHandlerFactory already set");
        }
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkSetFactory();
        }
        factory = fac;
    }

    public String toExternalForm() {
        return this.handler.toExternalForm(this);
    }

    public String toString() {
        return this.handler.toExternalForm(this);
    }

    private static synchronized URLStreamHandler getURLStreamHandler(String protocol) {
        URLStreamHandler handler = (URLStreamHandler)handlers.get(protocol);
        if (handler != null) {
            return handler;
        }
        if (factory != null) {
            handler = factory.createURLStreamHandler(protocol);
        } else if (protocol.equals("core")) {
            handler = new Handler();
        } else if (protocol.equals("file")) {
            handler = new gnu.gcj.protocol.file.Handler();
        }
        if (handler == null) {
            String propVal = System.getProperty("java.protocol.handler.pkgs");
            propVal = propVal == null ? "" : propVal + "|";
            propVal = propVal + "gnu.gcj.protocol|sun.net.www.protocol";
            StringTokenizer pkgPrefix = new StringTokenizer(propVal, "|");
            do {
                String facName = pkgPrefix.nextToken() + "." + protocol + ".Handler";
                try {
                    handler = (URLStreamHandler)Class.forName(facName).newInstance();
                }
                catch (Exception e) {
                    // empty catch block
                }
            } while ((handler == null || !(handler instanceof URLStreamHandler)) && pkgPrefix.hasMoreTokens());
        }
        if (handler != null) {
            if (handler instanceof URLStreamHandler) {
                handlers.put(protocol, handler);
            } else {
                handler = null;
            }
        }
        return handler;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.handler = URL.getURLStreamHandler(this.protocol);
        if (this.handler == null) {
            throw new IOException("Handler for protocol " + this.protocol + " not found");
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }
}

