/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class PushbackReader
extends FilterReader {
    private static final int DEFAULT_BUFFER_SIZE = 1;
    private char[] buf;
    private int pos;

    public PushbackReader(Reader in) {
        this(in, 1);
    }

    public PushbackReader(Reader in, int bufsize) {
        super(in);
        if (bufsize < 0) {
            throw new IllegalArgumentException("buffer size must be positive");
        }
        this.buf = new char[bufsize];
        this.pos = bufsize;
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.buf = null;
                super.close();
            }
            finally {
                Object var2_2 = null;
            }
            return;
        }
    }

    public void mark(int read_limit) throws IOException {
        throw new IOException("mark not supported in this class");
    }

    public boolean markSupported() {
        return false;
    }

    public void reset() throws IOException {
        throw new IOException("reset not supported in this class");
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            boolean bl;
            try {
                if (this.buf == null) {
                    throw new IOException("stream closed");
                }
                if (this.buf.length - this.pos > 0 || super.ready()) {
                    boolean bl2 = true;
                    Object var3_4 = null;
                    return bl2;
                }
                bl = false;
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                throw throwable;
            }
            Object var3_5 = null;
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long skip(long num_chars) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (num_chars <= 0L) {
                    return 0L;
                }
                if ((long)(this.buf.length - this.pos) >= num_chars) {
                    this.pos += (int)num_chars;
                    return num_chars;
                }
                int chars_discarded = this.buf.length - this.pos;
                this.pos = this.buf.length;
                long chars_skipped = this.in.skip(num_chars - (long)chars_discarded);
                return (long)chars_discarded + chars_skipped;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                throw throwable;
            }
        }
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n;
            try {
                if (this.buf == null) {
                    throw new IOException("stream closed");
                }
                if (this.pos == this.buf.length) {
                    int n2 = super.read();
                    Object var3_4 = null;
                    return n2;
                }
                ++this.pos;
                n = this.buf[this.pos - 1] & 0xFFFF;
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                throw throwable;
            }
            Object var3_5 = null;
            return n;
        }
    }

    public synchronized int read(char[] b, int offset, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n;
            try {
                if (this.buf == null) {
                    throw new IOException("stream closed");
                }
                if (offset < 0 || len < 0 || offset + len > b.length) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                int numBytes = Math.min(this.buf.length - this.pos, len);
                if (numBytes > 0) {
                    System.arraycopy(this.buf, this.pos, b, offset, numBytes);
                    this.pos += numBytes;
                    int n2 = numBytes;
                    Object var7_8 = null;
                    return n2;
                }
                n = super.read(b, offset, len);
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                throw throwable;
            }
            Object var7_9 = null;
            return n;
        }
    }

    public void unread(int b) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.buf == null) {
                    throw new IOException("stream closed");
                }
                if (this.pos == 0) {
                    throw new IOException("Pushback buffer is full");
                }
                --this.pos;
                this.buf[this.pos] = (char)b;
            }
            finally {
                Object var3_3 = null;
            }
            return;
        }
    }

    public synchronized void unread(char[] buf) throws IOException {
        this.unread(buf, 0, buf.length);
    }

    public synchronized void unread(char[] b, int offset, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.buf == null) {
                    throw new IOException("stream closed");
                }
                if (this.pos < len) {
                    throw new IOException("Pushback buffer is full");
                }
                System.arraycopy(b, offset, this.buf, this.pos - len, len);
                this.pos -= len;
            }
            finally {
                Object var5_5 = null;
            }
            return;
        }
    }
}

