/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.Buffers;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.SampleModel;
import java.util.Arrays;

public class ComponentSampleModel
extends SampleModel {
    protected int[] bandOffsets;
    protected int[] bankIndices;
    protected int numBanks;
    protected int scanlineStride;
    protected int pixelStride;
    private boolean tightPixelPacking;

    private /* synthetic */ void finit$() {
        this.tightPixelPacking = false;
    }

    public ComponentSampleModel(int dataType, int w, int h, int pixelStride, int scanlineStride, int[] bandOffsets) {
        this(dataType, w, h, pixelStride, scanlineStride, new int[bandOffsets.length], bandOffsets);
    }

    public ComponentSampleModel(int dataType, int w, int h, int pixelStride, int scanlineStride, int[] bankIndices, int[] bandOffsets) {
        super(dataType, w, h, bandOffsets.length);
        int b;
        this.finit$();
        if (pixelStride < 0 || scanlineStride < 0 || bandOffsets.length < 1 || bandOffsets.length != bankIndices.length) {
            throw new IllegalArgumentException();
        }
        this.bandOffsets = bandOffsets;
        this.bankIndices = bankIndices;
        for (b = 0; b < bankIndices.length; ++b) {
            this.numBanks = Math.max(this.numBanks, bankIndices[b] + 1);
        }
        this.scanlineStride = scanlineStride;
        this.pixelStride = pixelStride;
        if (pixelStride == this.numBands) {
            this.tightPixelPacking = true;
            for (b = 0; b < this.numBands; ++b) {
                if (bandOffsets[b] == b && bankIndices[b] == 0) continue;
                this.tightPixelPacking = false;
                break;
            }
        }
    }

    public SampleModel createCompatibleSampleModel(int w, int h) {
        return new ComponentSampleModel(this.dataType, w, h, this.pixelStride, this.scanlineStride, this.bankIndices, this.bandOffsets);
    }

    public SampleModel createSubsetSampleModel(int[] bands) {
        int numBands = bands.length;
        int[] bankIndices = new int[numBands];
        int[] bandOffsets = new int[numBands];
        for (int b = 0; b < numBands; ++b) {
            bankIndices[b] = this.bankIndices[bands[b]];
            bandOffsets[b] = this.bandOffsets[bands[b]];
        }
        return new ComponentSampleModel(this.dataType, this.width, this.height, this.pixelStride, this.scanlineStride, bankIndices, bandOffsets);
    }

    public DataBuffer createDataBuffer() {
        int highestOffset = 0;
        for (int b = 0; b < this.numBands; ++b) {
            highestOffset = Math.max(highestOffset, this.bandOffsets[b]);
        }
        int size = this.pixelStride * (this.width - 1) + this.scanlineStride * (this.height - 1) + highestOffset + 1;
        return Buffers.createBuffer(this.getDataType(), size, this.numBanks);
    }

    public int getOffset(int x, int y) {
        return this.getOffset(x, y, 0);
    }

    public int getOffset(int x, int y, int b) {
        return this.bandOffsets[b] + this.pixelStride * x + this.scanlineStride * y;
    }

    public final int[] getSampleSize() {
        int size = DataBuffer.getDataTypeSize(this.getDataType());
        int[] sizes = new int[this.numBands];
        Arrays.fill(sizes, size);
        return sizes;
    }

    public final int getSampleSize(int band) {
        return DataBuffer.getDataTypeSize(this.getDataType());
    }

    public final int[] getBankIndices() {
        return this.bankIndices;
    }

    public final int[] getBandOffsets() {
        return this.bandOffsets;
    }

    public final int getScanlineStride() {
        return this.scanlineStride;
    }

    public final int getPixelStride() {
        return this.pixelStride;
    }

    public final int getNumDataElements() {
        return this.numBands;
    }

    public Object getDataElements(int x, int y, Object obj, DataBuffer data) {
        int xyOffset = this.pixelStride * x + this.scanlineStride * y;
        int[] totalBandDataOffsets = new int[this.numBands];
        int[] bankOffsets = data.getOffsets();
        for (int b = 0; b < this.numBands; ++b) {
            totalBandDataOffsets[b] = this.bandOffsets[b] + bankOffsets[this.bankIndices[b]] + xyOffset;
        }
        try {
            switch (this.getTransferType()) {
                case 0: {
                    DataBufferByte inByte = (DataBufferByte)data;
                    byte[] outByte = (byte[])obj;
                    if (outByte == null) {
                        outByte = new byte[this.numBands];
                    }
                    for (int b = 0; b < this.numBands; ++b) {
                        int dOffset = totalBandDataOffsets[b];
                        outByte[b] = inByte.getData(this.bankIndices[b])[dOffset];
                    }
                    return outByte;
                }
                case 1: {
                    DataBufferUShort inUShort = (DataBufferUShort)data;
                    short[] outUShort = (short[])obj;
                    if (outUShort == null) {
                        outUShort = new short[this.numBands];
                    }
                    for (int b = 0; b < this.numBands; ++b) {
                        int dOffset = totalBandDataOffsets[b];
                        outUShort[b] = inUShort.getData(this.bankIndices[b])[dOffset];
                    }
                    return outUShort;
                }
                case 3: {
                    DataBufferInt inInt = (DataBufferInt)data;
                    int[] outInt = (int[])obj;
                    if (outInt == null) {
                        outInt = new int[this.numBands];
                    }
                    for (int b = 0; b < this.numBands; ++b) {
                        int dOffset = totalBandDataOffsets[b];
                        outInt[b] = inInt.getData(this.bankIndices[b])[dOffset];
                    }
                    return outInt;
                }
            }
            throw new IllegalStateException("unknown transfer type " + this.getTransferType());
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            String msg = "While reading data elements, x=" + x + ", y=" + y + ", " + ", xyOffset=" + xyOffset + ", data.getSize()=" + data.getSize() + ": " + aioobe;
            throw new ArrayIndexOutOfBoundsException(msg);
        }
    }

    public Object getDataElements(int x, int y, int w, int h, Object obj, DataBuffer data) {
        if (!this.tightPixelPacking) {
            return super.getDataElements(x, y, w, h, obj, data);
        }
        int rowSize = w * this.numBands;
        int dataSize = rowSize * h;
        DataBuffer transferBuffer = Buffers.createBuffer(this.getTransferType(), obj, dataSize);
        obj = Buffers.getData(transferBuffer);
        int inOffset = this.pixelStride * x + this.scanlineStride * y + data.getOffset();
        if (this.scanlineStride == rowSize) {
            rowSize *= h;
            h = 1;
        }
        int outOffset = 0;
        Object inArray = Buffers.getData(data);
        for (int yd = 0; yd < h; ++yd) {
            System.arraycopy(inArray, inOffset, obj, outOffset, rowSize);
            inOffset += this.scanlineStride;
            outOffset += rowSize;
        }
        return obj;
    }

    public void setDataElements(int x, int y, int w, int h, Object obj, DataBuffer data) {
        if (!this.tightPixelPacking) {
            super.setDataElements(x, y, w, h, obj, data);
            return;
        }
        int rowSize = w * this.numBands;
        int dataSize = rowSize * h;
        DataBuffer transferBuffer = Buffers.createBufferFromData(this.getTransferType(), obj, dataSize);
        int[] bankOffsets = data.getOffsets();
        int outOffset = this.pixelStride * x + this.scanlineStride * y + bankOffsets[0];
        if (this.scanlineStride == rowSize) {
            this.scanlineStride = rowSize *= h;
            h = 1;
        }
        int inOffset = 0;
        Object outArray = Buffers.getData(data);
        for (int yd = 0; yd < h; ++yd) {
            System.arraycopy(obj, inOffset, outArray, outOffset, rowSize);
            outOffset += this.scanlineStride;
            inOffset += rowSize;
        }
    }

    public int[] getPixel(int x, int y, int[] iArray, DataBuffer data) {
        int offset = this.pixelStride * x + this.scanlineStride * y;
        if (iArray == null) {
            iArray = new int[this.numBands];
        }
        for (int b = 0; b < this.numBands; ++b) {
            iArray[b] = data.getElem(this.bankIndices[b], offset + this.bandOffsets[b]);
        }
        return iArray;
    }

    public int[] getPixels(int x, int y, int w, int h, int[] iArray, DataBuffer data) {
        int offset = this.pixelStride * x + this.scanlineStride * y;
        if (iArray == null) {
            iArray = new int[this.numBands * w * h];
        }
        int outOffset = 0;
        for (y = 0; y < h; ++y) {
            int lineOffset = offset;
            for (x = 0; x < w; ++x) {
                for (int b = 0; b < this.numBands; ++b) {
                    iArray[outOffset++] = data.getElem(this.bankIndices[b], lineOffset + this.bandOffsets[b]);
                }
                lineOffset += this.pixelStride;
            }
            offset += this.scanlineStride;
        }
        return iArray;
    }

    public int getSample(int x, int y, int b, DataBuffer data) {
        return data.getElem(this.bankIndices[b], this.getOffset(x, y, b));
    }

    public void setDataElements(int x, int y, Object obj, DataBuffer data) {
        int offset = this.pixelStride * x + this.scanlineStride * y;
        int[] totalBandDataOffsets = new int[this.numBands];
        int[] bankOffsets = data.getOffsets();
        for (int b = 0; b < this.numBands; ++b) {
            totalBandDataOffsets[b] = this.bandOffsets[b] + bankOffsets[this.bankIndices[b]] + offset;
        }
        switch (this.getTransferType()) {
            case 0: {
                DataBufferByte out = (DataBufferByte)data;
                byte[] in = (byte[])obj;
                for (int b = 0; b < this.numBands; ++b) {
                    out.getData((int)this.bankIndices[b])[totalBandDataOffsets[b]] = in[b];
                }
                return;
            }
            case 1: {
                DataBufferUShort out = (DataBufferUShort)data;
                short[] in = (short[])obj;
                for (int b = 0; b < this.numBands; ++b) {
                    out.getData((int)this.bankIndices[b])[totalBandDataOffsets[b]] = in[b];
                }
                return;
            }
            case 3: {
                DataBufferInt out = (DataBufferInt)data;
                int[] in = (int[])obj;
                for (int b = 0; b < this.numBands; ++b) {
                    out.getData((int)this.bankIndices[b])[totalBandDataOffsets[b]] = in[b];
                }
                return;
            }
        }
        throw new UnsupportedOperationException("transfer type not implemented");
    }

    public void setPixel(int x, int y, int[] iArray, DataBuffer data) {
        int offset = this.pixelStride * x + this.scanlineStride * y;
        for (int b = 0; b < this.numBands; ++b) {
            data.setElem(this.bankIndices[b], offset + this.bandOffsets[b], iArray[b]);
        }
    }

    public void setSample(int x, int y, int b, int s, DataBuffer data) {
        data.setElem(this.bankIndices[b], this.getOffset(x, y, b), s);
    }
}

